--TRUNCATE TABLE ADM_TABLE_EVENT_LOG
--DROP TABLE ADM_TABLE_EVENT_AUDIT
CREATE TABLE ADM_TABLE_EVENT_AUDIT (

[ID]				BIGINT	 IDENTITY(1,1) PRIMARY KEY,
[HOSTNAME]			NVARCHAR(256)	DEFAULT HOST_NAME(),
[IP]				VARCHAR(MAX) DEFAULT CONVERT(VARCHAR(MAX),CONNECTIONPROPERTY('client_net_address')),
[APPNAME]			NVARCHAR(256)	DEFAULT APP_NAME(),
[USERNAME]          NVARCHAR(256)	DEFAULT SUSER_NAME(),
[TABLENAME]			SYSNAME,
[DATA]				DATE,
[HORA]				DATETIME,
[EVENTO]			XML,
[ACAO]				VARCHAR(30),
[COMMAND_TEXT]		VARCHAR(MAX))

GO

--SP_ENABLE_TABLE_AUDIT 'EST_PROD_CPL'
--DROP PROCEDURE SP_ENABLE_TABLE_AUDIT
CREATE PROCEDURE SP_ENABLE_TABLE_AUDIT @TABLENAME SYSNAME 
AS
BEGIN
	DECLARE @OBJNAME SYSNAME
	SET @OBJNAME = 'TRG_AUDIT_' + @TABLENAME + '_AUDIT'
	IF OBJECT_ID(@OBJNAME) IS NULL
	BEGIN
		DECLARE @CREATE_TRIGGER NVARCHAR(MAX)
		SET @CREATE_TRIGGER = 
			N'CREATE TRIGGER ' + @OBJNAME + ' ON ' + @TABLENAME + ' AFTER UPDATE, DELETE AS 
			BEGIN

				DECLARE @INPUTBUFFER TABLE (
					EVENTTYPE	NVARCHAR(30),
					PARAMETERS	INT,
					EVENTINFO	NVARCHAR(MAX));

				DECLARE @DELCOUNT INT;
				DECLARE @INSERTCOUNT INT;
				DECLARE @ACAO VARCHAR(30);
				DECLARE @COMANDO NVARCHAR(MAX);

				SET @COMANDO = ''DBCC INPUTBUFFER(@@spid) WITH NO_INFOMSGS'';

				INSERT	@INPUTBUFFER EXEC sp_executesql @COMANDO;

				SELECT @DELCOUNT = COUNT(*) FROM DELETED;
				SELECT @INSERTCOUNT = COUNT(*) FROM INSERTED;

				IF @DELCOUNT > 0 AND @INSERTCOUNT > 0
					SET @ACAO = ''UPDATE''

				IF @DELCOUNT > 0 AND @INSERTCOUNT = 0
					SET @ACAO = ''DELETE''

				SELECT @COMANDO = EVENTINFO FROM @INPUTBUFFER;

				INSERT INTO 
					ADM_TABLE_EVENT_AUDIT (TABLENAME, EVENTO, DATA, HORA, ACAO, COMMAND_TEXT) 
				VALUES 
					(''' + @TABLENAME + ''', 
					(SELECT * FROM DELETED FOR XML PATH (''Dados''), ROOT(''Audit'')), 
					GETDATE(), 
					GETDATE(),
					@ACAO,
					@COMANDO)
			END'
		EXECUTE SP_EXECUTESQL @CREATE_TRIGGER
	END
END

GO

--SP_DISABLE_TABLE_AUDIT 'EST_PROD'
--DROP PROCEDURE SP_DISABLE_TABLE_AUDIT
CREATE PROCEDURE SP_DISABLE_TABLE_AUDIT @TABLENAME SYSNAME
AS
BEGIN
	DECLARE @OBJNAME SYSNAME
	SET @OBJNAME = 'TRG_AUDIT_' + @TABLENAME + '_AUDIT'
	IF OBJECT_ID(@OBJNAME) IS NOT NULL
	BEGIN
		DECLARE @DROP_TRIGGER NVARCHAR(1000)
		SET @DROP_TRIGGER = N'DROP TRIGGER ' + @OBJNAME
		EXECUTE SP_EXECUTESQL @DROP_TRIGGER
	END
END
